function [wFilter2, wFilter] = NortchFilter( sp )
    wFilter.sp=sp;
    wFilter.wDenom=updateCache1(sp);
    wFilter2=1./(wFilter.wDenom+1.2^2);
end

function [ wDenom ] = updateCache1( sp )
    wDenom=zeros(2*sp.imgSize,2*sp.imgSize);
    for d=1:3
            wDenom=wDenom+1.0*WienerDenominatorNoAtt_2D(sp,d,1)+1.0*...
                WienerDenominatorUseAtt_2D(sp,d,2);   
    end
end

function [wFilter]=WienerFilterW2_2D( sp )
    wFilter.sp=sp;
    wFilter.wDenom=updateCache2(sp);
end

function [ wDenom ] = updateCache2( sp )
    Temp=sp.OtfProvider.otf;
    siz=size(Temp(:,:,1));
    w=siz(2);
    h=siz(1);
    wDenom=zeros(2*h,2*w);
    for d=1:3
        for b=1:2
            wd=wDenom;
            [wDenom]=addWienerDenominator_2D(wd,sp,d,b);
        end
    end
end

function [ wDenom ] = WienerDenominatorNoAtt_2D(sp,d,b)
    w=2*sp.imgSize;
    h=2*sp.imgSize;
    dir=sp.Dir(d);
    cyclMicron=sp.cyclesPerMicron;
    cnt=[h/2+1,w/2+1];

    x=1:w;
    y=1:h;
    [x,y]=meshgrid(x,y);


    rad1=hypot(x-cnt(2)-(b-1)*dir.px,y-cnt(1)-(b-1)*dir.py)*cyclMicron;   
    rad2=hypot(x-cnt(2)+(b-1)*dir.px,y-cnt(1)+(b-1)*dir.py)*cyclMicron;

    otfVal1=abs(getOtfVval(sp.OtfProvider,rad1)).^2;
    otfVal2=abs(getOtfVval(sp.OtfProvider,rad2)).^2;


    if b==1
        otfVal1=otfVal1/2;
        otfVal2=otfVal2/2;
    end
        wDenom=otfVal1+otfVal2;
end

function [wDenom] = WienerDenominatorUseAtt_2D(sp,d,b)
    w=2*sp.imgSize;
    h=2*sp.imgSize;
    dir=sp.Dir(d);
    cyclMicron=sp.cyclesPerMicron;
    cnt=[h/2+1,w/2+1];

    x=1:w;
    y=1:h;
    [x,y]=meshgrid(x,y);

    rad1=hypot(x-cnt(2)-(b-1)*dir.px,y-cnt(1)-(b-1)*dir.py)*cyclMicron;
    rad2=hypot(x-cnt(2)+(b-1)*dir.px,y-cnt(1)+(b-1)*dir.py)*cyclMicron;

    otfVal1=abs(getOtfVval(sp.OtfProvider,rad1)).^2;
    otfVal2=abs(getOtfVval(sp.OtfProvider,rad2)).^2;

    if b==1
        otfVal1=otfVal1.*valAttenuation(rad1,sp.OtfProvider.attStrength/1.00,sp.OtfProvider.attFWHM)/2;
        otfVal2=otfVal2.*valAttenuation(rad2,sp.OtfProvider.attStrength/1.00,sp.OtfProvider.attFWHM)/2;
    else        
        otfVal1=otfVal1.*valAttenuation(rad1,sp.OtfProvider.attStrength/1.00,1.0*sp.OtfProvider.attFWHM)/1.0;
        otfVal2=otfVal2.*valAttenuation(rad2,sp.OtfProvider.attStrength/1.00,1.0*sp.OtfProvider.attFWHM)/1.0;
    end
    wDenom=otfVal1+otfVal2;
end

function [wDenom]=addWienerDenominator_2D( wd,sp,d,b)
    siz=size(wd);
    w=siz(2);
    h=siz(1);
    dir=sp.Dir(d);
    cyclMicron=sp.cyclesPerMicron;
    cnt=[h/2+1,w/2+1];

    x=1:w;
    y=1:h;
    [x,y]=meshgrid(x,y);

    rad1=hypot(x-cnt(2)-(b-1)*dir.px,y-cnt(1)-(b-1)*dir.py)*cyclMicron;
    rad2=hypot(x-cnt(2)+(b-1)*dir.px,y-cnt(1)+(b-1)*dir.py)*cyclMicron;

    otfVal1=abs(getOtfVval(sp.OtfProvider,rad1)).^2;   
    otfVal2=abs(getOtfVval(sp.OtfProvider,rad2)).^2;

    if b==1
        if sp.OtfProvider.attStrength==0
            otfVal1=otfVal1/2;
            otfVal2=otfVal2/2;
        else
            otfVal1=otfVal1.*valAttenuation(rad1,sp.OtfProvider.attStrength/1.05,1.0*sp.OtfProvider.attFWHM)/2;
            otfVal2=otfVal2.*valAttenuation(rad2,sp.OtfProvider.attStrength/1.05,1.0*sp.OtfProvider.attFWHM)/2;
        end
    else
            otfVal1=otfVal1.*valAttenuation(rad1,sp.OtfProvider.attStrength/1.15,1.0*sp.OtfProvider.attFWHM)/1.0;
            otfVal2=otfVal2.*valAttenuation(rad2,sp.OtfProvider.attStrength/1.15,1.0*sp.OtfProvider.attFWHM)/1.0;
    end
    wd=wd+otfVal1+otfVal2;
    wDenom=wd;
end

function [A, params] = apodize_gauss(siz, params)

if nargin < 2 || ~isfield(params,'resolution')
  params.resolution = NaN;
end

if nargin < 2 || ~isfield(params,'rad')
  params.rad = 0.5;
end

if nargin < 2 || ~isfield(params,'offset')
  params.offset = [0 0];
end

if nargin < 1
  A.mfile = fileparts_name([mfilename('fullpath') '.m']);
  A.type = 'gauss';
  A.name = 'Gaussian';
  A.params = params;
  return;
end

assert(numel(siz) == 2 && any(siz > 0), 'apodize:siz', 'Wrong filter size.');

if isnan(params.resolution)
  rad = params.rad;
else
  rad = 2*params.resolution/params.rad;
end

cnt = ceil((siz+1)/2) + params.offset;
[x,y] = meshgrid(1:siz(2), 1:siz(1));
r = hypot((x-cnt(2))*2/siz(2), (y-cnt(1))*2/siz(1));

A = exp(-0.5*(r/rad*sqrt(2*log(2))).^2);
end

function [ val ]= getOtfVval(ret,cycl)
    mask=cycl>ret.cutoff;
    cycl(mask)=0; 

    pos=cycl./ret.cyclesPerMicron;
    cpos=pos+1;
    lpos=floor(cpos);
    hpos=ceil(cpos);
    f=(cpos-lpos); 

    retl=ret.vals(lpos).*(1-f);
    reth=ret.vals(hpos).*f;
    val=retl+reth;
    val(mask)=0;
end

function [va]= valAttenuation(dist,str,fwhm)
    va=1-str*(exp(-power(dist,2)/(power(0.5*fwhm,2))));
end



